using System;

namespace ConsoleApp3
{
    class Program
    {
        static int countPalindromeSwaps(string str)
        {
            char[] chars = str.ToCharArray();
            int count = 0;

            for (int i = 0; i < str.Length / 2; i++)
            {
                int left = i;

                int right = str.Length - left - 1;
                while (left < right)
                {
                    if (chars[left] == chars[right])
                    {
                        break;
                    }
                    else
                    {
                        right--;
                    }
                }

                if (left == right)
                {
                    return -1;
                }
                else
                {
                    for (int j = right; j < str.Length - left - 1; j++)
                    {
                        char t = chars[j];
                        chars[j] = chars[j + 1];
                        chars[j + 1] = t;
                        count++;
                    }
                }
            }

            return count;
        }

        public static void Main()
        {
            string word = Console.ReadLine();

            var swapCount = countPalindromeSwaps(word);
            var chars = word.ToCharArray();
            Array.Reverse(chars);
            var reverseSwapCount = countPalindromeSwaps(new string(chars));

            if (swapCount == 0 && reverseSwapCount == 0)
                Console.WriteLine(1);
            else
            {
                if (swapCount > reverseSwapCount)
                    Console.WriteLine(swapCount);
                else
                    Console.WriteLine(reverseSwapCount);
            }
        }
    }
}